/*  Bereitet Zeitfenster für arbeitsfreie Tage und Zeiten außerhalb der Schichtzeiten auf. Dabei werden sich üblappende
    Ausschaltzeiten zusammengefasst und der passende Typ gewählt.
*/
SET client_encoding TO 'UTF8'; --??? https://stackoverflow.com/questions/38481829/postgresql-character-with-byte-sequence-0xc2-0x81-in-encoding-utf8-has-no-equ
SELECT tsystem.function__drop_by_regex( 'resource_timeline__blocked_timeslots__generate', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__blocked_timeslots__generate(
      _shift_start_time time,
      _shift_end_time   time,
      _working_days     integer[],
      _startDate        timestamp,
      _stopDate         timestamp,
      _ta_fk            numeric DEFAULT 1.0
  ) RETURNS TABLE (
      date_start timestamp,
      date_end timestamp,
      type scheduling.resource_timeline_blocktype
  ) AS $$
  DECLARE
      _current_start timestamp;
      _current_end timestamp;
      _last_day_offday bool = false;
      _row_timestamp timestamp;
  BEGIN

    -- Zusätzlichen Tag verhindern, wenn das Zeitfensterende auf den Anfang der Folgetages zeigt (0 Uhr Folgetag, statt 24 Uhr eigentlich gemeinter Tag).
    IF _stopDate::time = '0:00:00'::time THEN
        _stopDate := _stopDate - interval '1 second';
    END IF;

    FOR _row_timestamp
    IN (

      SELECT generate_series(
            date_trunc('day', _startDate)::timestamp,
            date_trunc('day', _stopDate)::timestamp,
            '1 day'::interval
      ) dd

    ) LOOP

        -- generate off.days
        IF ( extract( DOW from _row_timestamp ) <> all ( _working_days ) ) OR _ta_fk = 0.0  THEN

            RETURN QUERY SELECT _row_timestamp, _row_timestamp + interval '1d', 'off.day'::scheduling.resource_timeline_blocktype;
            CONTINUE;

        END IF;

        -- if we have shifttimes from midnight to midnight we do not need to add more blocktimes
        -- this can be the case if the given times are equal or amount to a full day
        IF (
               _shift_start_time = _shift_end_time
            OR abs( extract ( epoch from _shift_start_time - _shift_end_time ) ) = 60 * 60 * 24
         ) THEN

            -- in this case we only need offdays eg. the weekends
            -- ┌─────────────────────┬─────────────────────┬─────────┐
            -- │     date_start      │      date_end       │  type   │
            -- ╞═════════════════════╪═════════════════════╪═════════╡
            -- │ 2018-08-04 00:00:00 │ 2018-08-05 00:00:00 │ off.day │ -> sat
            -- │ 2018-08-05 00:00:00 │ 2018-08-06 00:00:00 │ off.day │ -> sun
            -- │ 2018-08-11 00:00:00 │ 2018-08-12 00:00:00 │ off.day │ -> sat
            -- │ 2018-08-12 00:00:00 │ 2018-08-13 00:00:00 │ off.day │ -> sun
            -- └─────────────────────┴─────────────────────┴─────────┘
            CONTINUE;
        END IF;


        -- generate off.times
        IF (
               -- startdate => interval starts at midnight
               _row_timestamp = date_trunc('day', _startDate)

               -- day before was offday => interval starts at midnight
            OR extract( DOW FROM ( _row_timestamp - interval '1d' ) ) <> all( _working_days )

        ) THEN

            -- blocktime starts at midnight
            _current_start := _row_timestamp;

        ELSE

            -- blocktime starts the day before at shift end
            _current_start := _row_timestamp - interval '24h' + _shift_end_time;

        END IF;

        -- default for first part of day
        _current_end := _row_timestamp + _shift_start_time;

        -- emit row
        RETURN QUERY SELECT _current_start, _current_end, 'off.time'::scheduling.resource_timeline_blocktype;

        -- generate off.times end caps only if the following day is an offday or stopdate
        IF (
                extract( DOW from _row_timestamp + interval '1d' ) = any( _working_days )
            AND _row_timestamp + interval '1d' <= _stopDate
        ) THEN

            -- the data generation will be carried out by the first half of the loop.
            -- the second part is only needed for closing caps
            -- ┌─────────────────────┬─────────────────────┬──────────┐
            -- │     date_start      │      date_end       │   type   │
            -- ╞═════════════════════╪═════════════════════╪══════════╡
            -- │ 2018-08-07 00:00:00 │ 2018-08-07 08:00:00 │ off.time │ <--- start cap
            -- │ 2018-08-07 18:00:00 │ 2018-08-08 08:00:00 │ off.time │
            -- │ 2018-08-08 18:00:00 │ 2018-08-09 00:00:00 │ off.time │ <--- end cap
            -- └─────────────────────┴─────────────────────┴──────────┘

            CONTINUE;
        END IF;

        -- building end caps
        -- blocktime starts at shift end
        _current_start := _row_timestamp + _shift_end_time;

        -- second part of day
        IF (
              -- startdate => interval starts at midnight
               _row_timestamp = date_trunc('day', _stopDate)

               -- day before was offday => interval starts at midnight
            OR extract( DOW FROM ( _row_timestamp + interval '1d' ) ) <> all( _working_days )

        ) THEN

            -- next day no workday => ends at midnight
            _current_end := _row_timestamp + interval '1d';

        ELSE

            -- blocktime ends the day after at shift start
            _current_end := _row_timestamp + interval '1d' + _shift_start_time;

        END IF;

        RETURN QUERY SELECT _current_start, _current_end, 'off.time'::scheduling.resource_timeline_blocktype;

    END LOOP;

  END $$ language plpgsql;
